DIR_STACK="$HOME/.dir_stack"
touch "$DIR_STACK"

pa() {
    pwd >> "$DIR_STACK"
    echo "📌 Pasta salva: $(pwd)"
}

cds() {
    if [ ! -s "$DIR_STACK" ]; then
        echo "❌ Nenhuma pasta salva"
        return
    fi

    echo "📂 Pastas salvas:"
    nl -w2 -s") " "$DIR_STACK"

    read -p "Escolha: " n
    target=$(sed -n "${n}p" "$DIR_STACK")

    if [ -z "$target" ]; then
        echo "❌ Opção inválida"
        return
    fi

    cd "$target" || return
}

rms() {
    if [ ! -s "$DIR_STACK" ]; then
        echo "❌ Nada para remover"
        return
    fi

    nl -w2 -s") " "$DIR_STACK"
    read -p "Remover qual? " n
    sed -i "${n}d" "$DIR_STACK"
    echo "❌ Removido"
}

# Aliases com @
alias @pa='pa'
alias @cd='cds'
alias @rm='rms'
