#!/bin/bash

BASHRC="$HOME/.bashrc"

function list_aliases() {
    echo "📜 Aliases atuais:"
    grep '^alias' "$BASHRC"
}

function add_alias() {
    read -p "Nome do alias: " name
    read -p "Comando que ele deve executar: " cmd
    echo "alias $name='$cmd'" >> "$BASHRC"
    echo "✅ Alias '$name' adicionado!"
}

function remove_alias() {
    read -p "Nome do alias para remover: " name
    sed -i "/^alias $name=/d" "$BASHRC"
    echo "❌ Alias '$name' removido!"
}

function edit_bashrc() {
    nano "$BASHRC"
}

function reload_aliases() {
    source "$BASHRC"
    echo "🔄 Aliases recarregados!"
}

while true; do
    echo ""
    echo "===== Gerenciador de Aliases ====="
    echo "1) Listar aliases"
    echo "2) Adicionar alias"
    echo "3) Remover alias"
    echo "4) Editar .bashrc manualmente"
    echo "5) Recarregar aliases"
    echo "0) Sair"
    echo "=================================="
    read -p "Escolha uma opção: " opt

    case "$opt" in
        1) list_aliases ;;
        2) add_alias ;;
        3) remove_alias ;;
        4) edit_bashrc ;;
        5) reload_aliases ;;
        0) break ;;
        *) echo "Opção inválida!" ;;
    esac
done
